The [^](^) operation raises a numerical value to an exponential value expressing how many times the value is multiplied by itself.

## Syntax

> return_value = number [^](^) {whole_exponent|(fractional_exponent)}

## Description

* The number value can be any type literal or variable numerical value.
* Exponents can be any positive or negative integer or fractional numerical value inside of parenthesis brackets.
* If the exponent is zero, the value returned is 1.
* Fractional(or decimal point) exponents MUST be enclosed in **() brackets** and will return the fractional exponential root of a value. 
* Exponential operations are done first in the QBasic order of operations.
* The square root of a number can be returned by the [SQR](SQR) function or by using an exponent of (1 [/](/) 2). Brackets required.
* Values returned may be expressed using exponential or [Scientific notation](Scientific-notation) using **E** for SINGLE or **D** for DOUBLE precision.
* WARNING: Exponential returns may exceed numerical type limitations and create an [ERROR Codes](ERROR-Codes)! 

## Example(s)

 Getting the cube root of a number.

```vb

  INPUT "Enter a number to calculate it's cube root: ", num$
  number! = VAL(num$)   'gets single number value
  cuberoot# = number! ^ (1 / 3)
  PRINT cuberoot#       'double type variable for accuracy

```

*Details:* The value returned will most likely be a [SINGLE](SINGLE) or [DOUBLE](DOUBLE) value. Make sure that the return variable type matches the likely program operations!

```text

Enter a number to calculate it's cube root: 144
5.241482788417793


```

## See Also

* [SQR](SQR), [Mathematical Operations](Mathematical-Operations)
